-- Create some new 'member' tables ready for a partitioned view

IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_1992')
   DROP TABLE sales_1992
GO
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_1993')
   DROP TABLE sales_1993
GO
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_1994')
   DROP TABLE sales_1994
GO
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_1995')
   DROP TABLE sales_1995
GO
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_2008')
   DROP TABLE sales_2008
GO


CREATE TABLE [sales_1992] (
	[ord_year] [smallint] NOT NULL ,
	[stor_id] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_num] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_date] [datetime] NOT NULL ,
	[qty] [smallint] NOT NULL ,
	[payterms] [varchar] (12) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[title_id] [tid] NOT NULL ,
	CONSTRAINT [UPKCL_sales_1992] PRIMARY KEY  CLUSTERED 
	(
		[stor_id],
		[ord_num],
		[title_id],
		[ord_year]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK__sales_1999__storeid] FOREIGN KEY 
	(
		[stor_id]
	) REFERENCES [stores] (
		[stor_id]
	),
	CONSTRAINT [FK__sales_1999__titleid] FOREIGN KEY 
	(
		[title_id]
	) REFERENCES [titles] (
		[title_id]
	),
	CONSTRAINT [CK_sales_1992] CHECK ([ord_year] = 1992)
) ON [PRIMARY]
GO

CREATE TABLE [sales_1993] (
	[ord_year] [smallint] NOT NULL ,
	[stor_id] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_num] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_date] [datetime] NOT NULL ,
	[qty] [smallint] NOT NULL ,
	[payterms] [varchar] (12) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[title_id] [tid] NOT NULL ,
	CONSTRAINT [UPKCL_sales_1993] PRIMARY KEY  CLUSTERED 
	(
		[stor_id],
		[ord_num],
		[title_id],
		[ord_year]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK__sales_1993__storeid] FOREIGN KEY 
	(
		[stor_id]
	) REFERENCES [stores] (
		[stor_id]
	),
	CONSTRAINT [FK__sales_1993__titleid] FOREIGN KEY 
	(
		[title_id]
	) REFERENCES [titles] (
		[title_id]
	),
	CONSTRAINT [CK_sales_1993] CHECK ([ord_year] = 1993)
) ON [PRIMARY]
GO


CREATE TABLE [sales_1994] (
	[ord_year] [smallint] NOT NULL ,
	[stor_id] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_num] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_date] [datetime] NOT NULL ,
	[qty] [smallint] NOT NULL ,
	[payterms] [varchar] (12) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[title_id] [tid] NOT NULL ,
	CONSTRAINT [UPKCL_sales_1994] PRIMARY KEY  CLUSTERED 
	(
		[stor_id],
		[ord_num],
		[title_id],
		[ord_year]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK__sales_1994__storeid] FOREIGN KEY 
	(
		[stor_id]
	) REFERENCES [stores] (
		[stor_id]
	),
	CONSTRAINT [FK__sales_1994__titleid] FOREIGN KEY 
	(
		[title_id]
	) REFERENCES [titles] (
		[title_id]
	),
	CONSTRAINT [CK_sales_1994] CHECK ([ord_year] = 1994)
) ON [PRIMARY]
GO


CREATE TABLE [sales_1995] (
	[ord_year] [smallint] NOT NULL ,
	[stor_id] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_num] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_date] [datetime] NOT NULL ,
	[qty] [smallint] NOT NULL ,
	[payterms] [varchar] (12) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[title_id] [tid] NOT NULL ,
	CONSTRAINT [UPKCL_sales_1995] PRIMARY KEY  CLUSTERED 
	(
		[stor_id],
		[ord_num],
		[title_id],
		[ord_year]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK__sales_1995__storeid] FOREIGN KEY 
	(
		[stor_id]
	) REFERENCES [stores] (
		[stor_id]
	),
	CONSTRAINT [FK__sales_1995__titleid] FOREIGN KEY 
	(
		[title_id]
	) REFERENCES [titles] (
		[title_id]
	),
	CONSTRAINT [CK_sales_1995] CHECK ([ord_year] = 1995)
) ON [PRIMARY]
GO


CREATE TABLE [sales_2008] (
	[ord_year] [smallint] NOT NULL ,
	[stor_id] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_num] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ord_date] [datetime] NOT NULL ,
	[qty] [smallint] NOT NULL ,
	[payterms] [varchar] (12) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[title_id] [tid] NOT NULL ,
	CONSTRAINT [UPKCL_sales_2008] PRIMARY KEY  CLUSTERED 
	(
		[stor_id],
		[ord_num],
		[title_id],
		[ord_year]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK__sales_2008__storeid] FOREIGN KEY 
	(
		[stor_id]
	) REFERENCES [stores] (
		[stor_id]
	),
	CONSTRAINT [FK__sales_2008__titleid] FOREIGN KEY 
	(
		[title_id]
	) REFERENCES [titles] (
		[title_id]
	),
	CONSTRAINT [CK_sales_2008] CHECK ([ord_year] = 2008)
) ON [PRIMARY]
GO


-- OK that's our base tables created, let's populate them from that original sales table
INSERT INTO sales_1992
SELECT 1992,* FROM sales
WHERE DATEPART(YY,ord_date) = 1992

INSERT INTO sales_1993
SELECT 1993,* FROM sales
WHERE DATEPART(YY,ord_date) = 1993

INSERT INTO sales_1994
SELECT 1994, * FROM sales
WHERE DATEPART(YY,ord_date) = 1994

INSERT INTO sales_1995
SELECT 1995, * FROM sales
WHERE DATEPART(YY,ord_date) = 1995

--Just to check we have some data in these 'member' tables
SELECT * FROM sales_1992
SELECT * FROM sales_1994
GO

--OK, now we want to create a Partitioned View as
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'Partitioned_Sales')
   DROP VIEW Partitioned_Sales
GO

CREATE VIEW Partitioned_Sales AS
(
SELECT * FROM sales_1992
UNION ALL
SELECT * FROM sales_1993
UNION ALL
SELECT * FROM sales_1994
UNION ALL
SELECT * FROM sales_1995
UNION ALL
SELECT * FROM sales_2008
)
GO

--Try it out and look at the execution plan
SELECT * FROM Partitioned_Sales
GO

--Try a query based upon order date

SELECT * FROM Partitioned_Sales
WHERE DATEPART(YY,ord_date) = 1994
GO

--However, what does the Database Engine do when we use the 'key' criteria
SELECT * FROM Partitioned_Sales
WHERE ord_year = 1993
GO

--What about data insertion - into the view, can it handle it and work out which
--member table to insert data into 

INSERT INTO Partitioned_Sales
VALUES (2008, 8042, 5027, CAST('03/04/2008' AS DATETIME),20,'Net 60','PC1035')
GO

SELECT * FROM Partitioned_Sales
ORDER BY ord_year DESC
GO